#!/bin/sh
# Start tclsh \
exec tclsh8.5 "$0" "$@"


if {[catch {package require k8055m}]} {
    load tclk8055m.dll Tclk8055m
}

k8055m_init
k8055m_open 0

# console show

proc main {argc argv} {
    global	stat

    foreach port {0 1 2 3 4 5 6 7} name {O1 O2 O3 O4 O5 O6 O7 O8} {
        set stat(${name}_mode) [k8055m_get_digital_mode 0 $port]
	set stat(${name}_normal_value) [k8055m_get_digital_out 0 $port]
	k8055m_get_servo 0 $port stat(${name}_servo_pulse) stat(${name}_servo_high)
    }

    frame .all
    pack .all -side top -fill both -expand true

    digital_out	.all.o0 0 O1
    pack	.all.o0 -side left -fill both -expand true

    digital_out	.all.o1 1 O2
    pack	.all.o1 -side left -fill both -expand true

    digital_out	.all.o2 2 O3
    pack	.all.o2 -side left -fill both -expand true

    digital_out	.all.o3 3 O4
    pack	.all.o3 -side left -fill both -expand true

    digital_out	.all.o4 4 O5
    pack	.all.o4 -side left -fill both -expand true

    digital_out	.all.o5 5 O6
    pack	.all.o5 -side left -fill both -expand true

    digital_out	.all.o6 6 O7
    pack	.all.o6 -side left -fill both -expand true

    digital_out	.all.o7 7 O8
    pack	.all.o7 -side left -fill both -expand true
}


# ----------
# digital_out
#
#	Create all the controls for one digital output
# ----------
proc digital_out {w port name} {
    global	stat

    frame	$w		-borderwidth 1 -relief sunken

    grid columnconfigure $w 0 -weight 0
    grid columnconfigure $w 1 -weight 0
    grid columnconfigure $w 2 -weight 1

    grid rowconfigure $w 0 -weight 0

    # ----
    # We use a separate frame to place the 4 digital out mode radiobuttons
    # ----
    frame	$w.mf		-borderwidth 0 -relief flat
    grid	$w.mf		-in $w -column 0 -row 0 -columnspan 3		\
    				-sticky we

    grid columnconfigure $w.mf 0 -weight 0
    grid columnconfigure $w.mf 1 -weight 0
    grid columnconfigure $w.mf 2 -weight 1

    label	$w.mf.lbl	-borderwidth 0 -relief flat			\
    				-text "$name Mode:"
    grid	$w.mf.lbl	-in $w.mf -column 0 -row 0 -padx 2 -pady 2

    radiobutton	$w.mf.mode0	-borderwidth 2 -relief raised			\
    				-text "NORMAL" -state normal -anchor w		\
				-variable stat(${name}_mode) -value NORMAL	\
				-command [list digital_out_change_mode $w $port $name]
    grid	$w.mf.mode0	-in $w.mf -column 1 -row 0 -sticky we -padx 2 -pady 2

    radiobutton	$w.mf.mode1	-borderwidth 2 -relief raised			\
    				-text "SERVO" -state normal -anchor w		\
				-variable stat(${name}_mode) -value SERVO	\
				-command [list digital_out_change_mode $w $port $name]
    grid	$w.mf.mode1	-in $w.mf -column 1 -row 1 -sticky we -padx 2 -pady 2

    radiobutton	$w.mf.mode2	-borderwidth 2 -relief raised			\
    				-text "Reserved" -state disabled -anchor w	\
				-variable stat(${name}_mode) -value RESERVED	\
				-command [list digital_out_change_mode $w $port $name]
    grid	$w.mf.mode2	-in $w.mf -column 1 -row 2 -sticky we -padx 2 -pady 2

    radiobutton	$w.mf.mode3	-borderwidth 2 -relief raised			\
    				-text "Reserved" -state disabled -anchor w	\
				-variable stat(${name}_mode) -value RESERVED	\
				-command [list digital_out_change_mode $w $port $name]
    grid	$w.mf.mode3	-in $w.mf -column 1 -row 3 -sticky we -padx 2 -pady 2


    # ----
    # One checkbutton to control the ON/OFF value in NORMAL mode
    # ----
    checkbutton	$w.onoff	-borderwidth 2 -relief raised			\
    				-text "Normal ON/OFF"				\
				-variable stat(${name}_normal_value)		\
				-onvalue 1 -offvalue 0				\
				-command [list digital_out_change_value $w $port $name]
    grid	$w.onoff	-in $w -column 0 -row 1 -padx 2 -pady 2

    # ----
    # A check button for high/low pulse in SERVO mode
    # ----
    checkbutton	$w.highlow	-borderwidth 2 -relief raised			\
    				-text "Pulse High"				\
				-variable stat(${name}_servo_high)		\
				-onvalue 1 -offvalue 0				\
				-command [list digital_out_change_servo $w $port $name]
    grid	$w.highlow	-in $w -column 0 -row 2 -padx 2 -pady 2

    scale	$w.pulse	-borderwidth 2 -relief sunken			\
    				-orient vertical -length 256			\
				-from 2400.0 -to 500.0 -showvalue true		\
				-variable stat(${name}_servo_pulse)		\
				-command [list digital_out_change_servo $w $port $name]
    grid	$w.pulse	-in $w -column 0 -row 3 -padx 2 -pady 2


    return $w
}


proc digital_out_change_mode {w port name} {
    global	stat

    k8055m_set_digital_mode 0 $port $stat(${name}_mode)
}


proc digital_out_change_value {w port name} {
    global	stat

    k8055m_set_digital_out 0 $port $stat(${name}_normal_value)
}


proc digital_out_change_servo {w port name args} {
    global	stat

    k8055m_set_servo 0 $port $stat(${name}_servo_pulse) $stat(${name}_servo_high)
}


main $argc $argv
